package cn.com.duiba.kjy.api.enums.push;

/**
 * 热文推送排序操作枚举
 * @author panchao
 * date 2019-10-11
 */
public enum HotArticleSortOperateEnum {

    TO_UP(1, "上移"),
    TO_DOWN(2,"下移"),
    ;
    private Integer code;

    private String desc;

    HotArticleSortOperateEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static HotArticleSortOperateEnum getByCode(Integer code) {
        for (HotArticleSortOperateEnum enumVal : HotArticleSortOperateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (HotArticleSortOperateEnum enumVal : HotArticleSortOperateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
