package cn.com.duiba.kjy.api.params.layer;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 弹层配置查询
 * @author 吴文哲
 * @date 2020-03-25 17:08
 **/
@Data
public class LayerConfigQueryParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = -4218413866181769769L;

    /**
     * 主键
     */
    private Long id;


    /**
     * @see cn.com.duiba.kjy.api.enums.layer.LayerConfigStateEnum
     *
     */
    private Integer configState;

    /**
     *
     *生效开始时间
     * not null default = null
     */
    private Date availableStartTime;

    /**
     *
     *生效结束时间
     * not null default = null
     */
    private Date availableEndTime;

    /**
     * 当前时间以后
     */
    private Date afterNowTime;

    /**
     * 展示的页面
     */
    private Integer displayPage;

}
