package cn.com.duiba.kjy.api.params.content;

import cn.com.duiba.kjy.api.constant.ContentStatusEnum;
import cn.com.duiba.kjy.api.enums.ContentSellerImportEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author linjianhui
 * @description  查询条件
 * @date 2020-02-08 01:03
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ContentEsParam  extends PageQuery {
    /**
     * 文章标题  es类型 text
     */
    private String title;

    /**
     * 内容id列表
     */
    private List<Long> contentIds;

    /**
     * 内容状态 es类型 integer
     */
    private ContentStatusEnum contentStatusEnum;

    /**
     * 多状态
     */
    private List<Integer> statusList;

    /**
     * 是否公有 es类型 integer
     */
    private Integer contentPublicly;

    /**
     * 公司id
     */
    private Long contentCompany;

    /**
     * 公司专区id的公司id
     */
    private Long companyAreaCompanyId;

    /**
     * 种草素材公司id
     */
    private Long grassContentCompanyId;

    /**
     * 内容类型列表
     */
    private List<String> contentTypeList;

    /**
     * 一级标签id列表
     */
    private List<Long> firstTagIdList;

    /**
     * 二级标签id列表
     */
    private List<Long> secondTagIdList;

    /**
     * 三级标签id列表
     */
    private List<Long> thirdTagIdList;

    /**
     * 是否按照分享数排序
     * true：按照分享数，不传/false：按照创建时间
     */
    private Boolean shareNum;

    /**
     * 管理后台视频排序
     */
    private Boolean videoSort;
    /**
     * 用户 客集集的版本  1:通用版  2:保险专业版  非通用版可以看通用版的数据
     */
    private List<Integer> userVersion;
    /**
     * 是否推荐，0=不是、1=是
     */
    private Integer recommend;

    /**
     * 是否按照sort排序
     * true：按照sort，不传/false：按照创建时间
     */
    private Boolean sort;
    /**
     * 是否按照发布时间排序
     * true：按照发布时间，不传/false：按照创建时间
     */
    private Boolean releaseTime;

    /**
     * 发圈素材排序  发布时间 > 优先级 > 创建时间
     */
    private Boolean timelineSort;

    /**
     * 最后创建时间，前台海报处用
     */
    private Date endDate;

    /**
     * 筛选发布时间（开始）
     */
    private Date startReleaseTime;

    /**
     * 筛选发布时间（结束）
     */
    private Date endReleaseTime;

    /**
     * 筛选创建时间（开始）
     */
    private Date startCreateTime;

    /**
     * 筛选创建时间（结束）
     */
    private Date endCreateTime;

    /**
     * 筛选定时发布时间（开始）
     */
    private Date startTimeOpening;

    /**
     * 筛选定时发布时间（结束）
     */
    private Date endTimeOpening;

    /**
     * 是否是销售员上传的
     * @see ContentSellerImportEnum
     */
    private Integer sellerImport;

    /**
     * true 分词器采用and模式，不传或者false采用or
     */
    private Boolean analyzer;

    /**
     * 根据阅读数排序
     */
    private Boolean OrderByReadNum;

    /**
     * 根据转发率排序
     */
    private Boolean OrderByForwardRate;

    /**
     * 是否倒序
     */
    private Boolean isDesc = Boolean.TRUE;

    /**
     * 客户成功案例名称
     */
    private String caseName;

    /**
     * 是否按照客户成功案例的 listOrder倒序
     * true:表示倒序  其它都表示不进行倒序
     */
    private Boolean orderByCaseListOrder;

    /**
     * 发圈素材独有的 推荐优先级 1低，2中，3高 4:时段置顶
     * @see cn.com.duiba.kjy.api.enums.grabmaterial.RecommendPriorityEnum
     */
    private Integer recommendPriority;

    /**
     * 是否为种草素材
     * 1:是 2:否
     */
    private Integer isGrassContent;

    /**
     * 是否为发圈素材
     * 1:是 2:否
     */
    private Integer isTimelineContent;

    /**
     * 发圈素材类型
     * @see cn.com.duiba.kjy.api.enums.grabmaterial.GrabMaterialTypeEnum
     *
     **/
    private Integer timelineContentType;

    /**
     * 发圈素材未读的代理人列表
     */
    private Set<Long> timelineUnReadSellerIds;

    /**
     * 不包含的素材id列表
     */
    private List<Long> excludeContentIds;

    /**
     * 上传人员Ids
     */
    private List<Long> importSellerIds;

    /**
     * 是否内部人员上传
     */
    private Boolean innerUpload;


}
