package cn.com.duiba.kjy.api.remoteservice.interaction;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.interaction.ContentInteractionTemplateDetailDto;
import cn.com.duiba.kjy.api.dto.interaction.InteractionTemplateContentDetailDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.interaction.ContentInteractionRelationSearchParams;
import cn.com.duiba.kjy.api.params.interaction.ContentInteractionTemplateSearchParams;

/**
 * @author lizhi
 * @date 2019/9/23 2:03 PM
 */
@AdvancedFeignClient
public interface RemoteContentInteractionTemplateService {

    /**
     * 新增或更新模板
     * @param templateDto 模板参数
     * @return 主键
     */
    Long saveOrUpdateTemplate(ContentInteractionTemplateDetailDto templateDto);

    /**
     * 根据主键从缓存中查询模板及模板详细信息
     * @param id 主键
     * @return 模板及模板详细信息
     */
    ContentInteractionTemplateDetailDto findDetailByIdCache(Long id);

    /**
     * 根据主键查询模板
     * @param id 主键
     * @return 模板
     */
    ContentInteractionTemplateDetailDto findById(Long id);

    /**
     * 分页查询
     * @param params 分页查询参数
     * @return 列表
     */
    Page<ContentInteractionTemplateDetailDto> findPage(ContentInteractionTemplateSearchParams params);

    /**
     * 删除模板
     * @param id 主键
     * @return 执行结果
     */
    int deleted(Long id);

    /**
     * 更改模板状态
     * @param id 主键
     * @param state 状态
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateStateEnum
     * @return 执行结果
     */
    int updateState(Long id, Integer state);

    /**
     * 根据模板主键查询内容详情
     * @param params 参数
     * @return 模版对应内容详情
     */
    Page<InteractionTemplateContentDetailDto> findContentDetailPage(ContentInteractionRelationSearchParams params);

    /**
     * 根据标签ID，随机获取模板
     * @param tag1Id 一级标签ID
     * @param tag2Id 二级标签ID
     * @return 模板详情
     */
    ContentInteractionTemplateDetailDto findRandomTemplate(Long tag1Id, Long tag2Id);

    /**
     * 随机获取互动题库通用模板
     * @return 模板详情
     */
    ContentInteractionTemplateDetailDto findRandomGeneralTemplate();
}

