package cn.com.duiba.kjy.api.remoteservice.successCases;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.successCases.SuccessCasesDto;
import cn.com.duiba.kjy.api.params.successCases.SuccessCasesLockParam;
import cn.com.duiba.kjy.api.params.successCases.SuccessCasesMoveParam;
import cn.com.duiba.kjy.api.params.successCases.SuccessCasesQueryParam;

import java.util.List;
import java.util.Map;

/**
 * 成功案例rpc接口
 * @author 吴文哲
 * @date 2020-05-15 11:34
 **/
@AdvancedFeignClient
public interface RemoteSuccessCasesService {


    /**
     * 根据素材id 获取素材对应的成功案例对象
     * @param contentIds
     * @return
     */
    Map<Long, SuccessCasesDto> getContentId2CaseDtoMap(List<Long> contentIds);
    /**
     * 新增成功案例
     * @param successCasesDto
     * @return
     */
    Integer addSuccessCases(SuccessCasesDto successCasesDto) throws KjyCenterException;

    /**
     * 修改成功案例
     * @param successCasesDto
     * @return
     */
    Integer updateSuccessCases(SuccessCasesDto successCasesDto) throws KjyCenterException;

    /**
     * 移动成功案例
     * @param moveParam
     * @return
     */
    Integer move(SuccessCasesMoveParam moveParam) throws KjyCenterException;

    /**
     * 锁定/解锁 成功案例
     * @param lockParam
     * @return
     */
    Integer lock(SuccessCasesLockParam lockParam) throws KjyCenterException;

    /**
     * 删除成功案例
     * @param id
     * @return
     */
    Integer delCases(Long id);

    /**
     * 根据主键查找
     * @param contentId
     * @return
     */
    SuccessCasesDto findByContentId(Long contentId);
}
