/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import java.lang.reflect.Field;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);

    public static boolean isAllFieldNull(Object obj) {
        Field[] fields;
        if (obj == null) {
            return true;
        }
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object object = field.get(obj);
                if (!Objects.nonNull(object)) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                log.error("IllegalAccessException:", (Throwable)e);
            }
        }
        return true;
    }

    public static boolean isAllFieldNotNull(Object obj) {
        Field[] fields;
        if (obj == null) {
            return false;
        }
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object object = field.get(obj);
                if (!Objects.isNull(object)) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                log.error("IllegalAccessException:", (Throwable)e);
            }
        }
        return true;
    }

    public static boolean isAllFieldNotBlank(Object obj) {
        Field[] fields;
        if (obj == null) {
            return false;
        }
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object object = field.get(obj);
                if (!Objects.isNull(object) && !object.toString().equals("")) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                log.error("IllegalAccessException:", (Throwable)e);
            }
        }
        return true;
    }
}

