package cn.com.duiba.kjy.api.enums.push;

import java.util.Objects;

/**
 * @auther: linjianhui
 * @date: 2019-08-08 18:34
 * @description:
 */
public enum  PushManagerEnableEnum {
    /**
     * 是否启用推送，1=启用、2=未启用
     */
    ENABLE(1, "启用"),
    NOT_ENABLE(2, "未启用"),
    ;

    private Integer code;

    private String desc;

    PushManagerEnableEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PushManagerEnableEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (PushManagerEnableEnum pushManagerEnableEnum : values()) {
            if (Objects.equals(pushManagerEnableEnum.getCode(), code)) {
                return pushManagerEnableEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
