package cn.com.duiba.kjy.api.dto.sellerCustomerInfoExt;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售客户信息拓展表
 * @author kjj mybatis generator 
 * 2020-04-28
 */
@Data
public class SellerCustomerInfoExtDto implements Serializable {
    private static final long serialVersionUID = 15880482035183451L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *客户表id，对应tb_seller_customer.id
     * not null default = null
     */
    private Long customerId;

    /**
     *
     *年龄
     */
    private Integer age;

    /**
     *
     *年收入
     * max length = 50
     */
    private String yearIncome;

    /**
     *
     *是否有车，0无，1有
     */
    private Boolean haveCar;

    /**
     *
     *是否有房
     */
    private Boolean haveHouse;

    /**
     *
     *家庭情况
     * max length = 125
     */
    private String familyStatus;

    /**
     *
     *健康情况
     * max length = 125
     */
    private String healthStatus;

    /**
     *
     *保险购买情况
     * max length = 125
     */
    private String insuranceBuyStatus;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 阅读偏好
     */
    private String readPreference;
}