/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.params.seller.VisitListTypeEnum;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class CusActionConvertorUtil {
    public static final int LENGTH = 5;

    public static String getBinaryString(Integer dbVal) {
        return CusActionConvertorUtil.decimal2Binary(dbVal, 5);
    }

    public static Integer getOctalInteger(String binaryString) {
        return Integer.valueOf(binaryString, 2);
    }

    public static Integer getNewActionTypeInteger(Integer actionType, String binaryStr) {
        String pre = binaryStr.substring(0, 5 - actionType);
        String suf = binaryStr.substring(5 - actionType + 1, 5);
        return CusActionConvertorUtil.getOctalInteger(pre + "1" + suf);
    }

    public static List<Integer> getAllResult(int start, int end) {
        LinkedList<Integer> resultList = new LinkedList<Integer>();
        int total = 32;
        for (int i = 0; i < total; ++i) {
            String binaryStr = CusActionConvertorUtil.decimal2Binary(i, 5);
            if (!Objects.equals(binaryStr.substring(start, end), "1")) continue;
            resultList.add(Integer.valueOf(binaryStr, 2));
        }
        return resultList;
    }

    public static List<Integer> getActionTypeIntList(Integer actionType) {
        if (Objects.isNull(actionType)) {
            return null;
        }
        VisitListTypeEnum typeEnum = VisitListTypeEnum.getByCode(actionType);
        List<Integer> resultList = null;
        int start = 5 - actionType;
        int end = start + 1;
        switch (typeEnum) {
            case MATERIAL: {
                resultList = CusActionConvertorUtil.getAllResult(start, end);
                break;
            }
            case LOTTERY: {
                resultList = CusActionConvertorUtil.getAllResult(start, end);
                break;
            }
            case FORWARD: {
                resultList = CusActionConvertorUtil.getAllResult(start, end);
                break;
            }
            case QUESTION: {
                resultList = CusActionConvertorUtil.getAllResult(start, end);
                break;
            }
            case VOTE: {
                resultList = CusActionConvertorUtil.getAllResult(start, end);
                break;
            }
            default: {
                return null;
            }
        }
        return resultList;
    }

    public static String decimal2Binary(int decNum, int digit) {
        String binStr = "";
        for (int i = digit - 1; i >= 0; --i) {
            binStr = binStr + (decNum >> i & 1);
        }
        return binStr;
    }
}

