package cn.com.duiba.kjy.api.dto.vipTransfer;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.kjy.api.enums.vip.VipTransferCheckStateEnum;
import lombok.Data;

/**
 * 付费会员转移记录表
 * @author kjj mybatis generator
 * 2020-05-08
 */
@Data
public class VipTransferVerifyRecordDto implements Serializable {
    private static final long serialVersionUID = 1588917835857305L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *转移前代理人id
     * not null default = null
     */
    private Long oldSellerId;

    /**
     *
     *转移后代理人id
     * not null default = 0
     */
    private Long newSellerId;

    /**
     *
     *操作人id
     * not null default = 0
     */
    private Long operatorId;

    /**
     *
     *操作人
     * max length = 32
     * not null default =
     */
    private String operatorAccount;

    /**
     *
     * 审核状态 0:发起申请 1:待审核 2:审核通过 3:审核拒绝
     * @see VipTransferCheckStateEnum
     */
    private Integer checkState;

    /**
     *
     *审核原因
     * max length = 200
     * not null default =
     */
    private String checkReason;

    /**
     *
     *备注
     * max length = 200
     * not null default =
     */
    private String remark;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

}
