package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author wutong
 * @date: 2020-06-10 19:56
 * @description: 查询销售发布的文章列表参数
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerContentQueryParams extends PageQuery {

    private static final long serialVersionUID = 6418697705063680325L;

    /**
     * 内容类型
     */
    private Long sellerId;

    /**
     * 内容类型
     */
    private String contentType;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 内容id列表
     */
    private List<Long> contentIds;

    /**
     * 是否根据阅读数倒叙排列
     */
    private boolean orderByReadNumDesc = false;

    /**
     * 是否过滤掉阅读数小于等于0的数据
     */
    private boolean filterZeroReadNum = false;
}
