package cn.com.duiba.kjy.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.tag.TagExtDto;

import java.util.List;

/**
 * 标签拓展信息rpc接口
 *
 * @author 吴文哲
 * @date 2020-05-06 15:47
 **/
@AdvancedFeignClient
public interface RemoteTagExtService {

    /**
     * 标签拓展信息修改
     *
     * @param tagExtDto
     * @return
     */
    Integer edit(TagExtDto tagExtDto);

    /**
     * 查找全部 供manager调用
     * @return
     */
    List<TagExtDto> findAll();

    /**
     * 根据标签id查找
     * @param tagIds
     * @return
     */
    List<TagExtDto> findByTagIds(List<Long> tagIds);
}
