package cn.com.duiba.kjy.api.dto.vip;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @auther wuwenzhe
 * @date 2019-07-26 15:21
 */
@Data
public class SellerPayRecordDto implements Serializable{


    private static final long serialVersionUID = -6431079131593568507L;

    private Long id;

    /**
     * 微信交易号
     */
    private String payTradeNo;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 销售微信昵称
     */
    private String nickName;

    /**
     * 上级ID(seller_id)
     */
    private Long superiorId;

    /**
     * 上级销售微信昵称
     */
    private String superiorNickName;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 创建时间
     */
    private Date gmtCreate;


    /**
     * 套餐Id
     */
    private Long comboId;

    /**
     * 购买类型(套餐名称)
     */
    private String comboName;


    /**
     * 付款金额，单位：分
     */
    private Long amount;


    /**
     * 支付状态
     */
    private Integer payStatus;

    /**
     * 支付状态描述
     */
    private String payStatusDesc;

    /**
     * 代付人id  userId
     */
    private Long presentUserId;

    /**
     * 是否代付  1:是 0:否
     */
    private Integer presentPay;

    /**
     * 支付结果时间
     */
    private Date payResultTime;

    /**
     * 支付成功时间  只有支付成功才会有支付成功时间
     */
    private Date paySuccTime;

    /**
     * 优惠码批次ID
     */
    private Long batchId;
}
