package cn.com.duiba.kjy.api.remoteservice.grabmaterial;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.grabmaterial.GrabAccountDto;

import java.util.List;

/**
 * 爬虫所使用的账号
 * @Author chentiecheng
 * @Date 2020/3/9 7:49 下午
 */
@AdvancedFeignClient
public interface RemoteGrabUsedAccountService {
    /**
     * 新增账号
     * @param grabAccountDto
     * @return
     */
    Boolean insert(GrabAccountDto grabAccountDto);

    /**
     * 批量新增账号
     * @param dtos
     * @return
     */
    Boolean batchInsert(List<GrabAccountDto> dtos);

    /**
     * 根据md5加密后的cookie查询记录
     * @param cookieMd5
     * @return
     */
    GrabAccountDto selectAccountByCookieMd5(String cookieMd5);

    /**
     * 根据账号和类型判断账号是否存在
     * @param name
     * @param type
     * @return
     */
    Boolean isExist(String name,Integer type);

    /**
     * 更新所有账号状态
     * @return
     */
    Integer updateAllAccountStatus(Integer status);

    /**
     * 批量更新账号
     * @return
     */
    Integer batchUpdate(List<GrabAccountDto> list);

    /**
     * 根据类型获取所有账，主要用于登录
     * @param type
     * @return
     */
    List<GrabAccountDto> selectAllAccountForLogin(Integer type);


}
