package cn.com.duiba.kjy.api.remoteservice.invitationLetter;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.invitationLetter.SellerInvitationLetterConfDetailDto;
import cn.com.duiba.kjy.api.dto.invitationLetter.SellerInvitationLetterConfDto;
import cn.com.duiba.kjy.api.params.invitationLetter.MyInvitationLetterParam;

import java.util.List;

/**
 * 邀请函配置 rpc 接口
 * @author 吴文哲
 * @date 2020-02-19 13:49
 **/
@AdvancedFeignClient
public interface RemoteSellerInvitationLetterConfService {

    /**
     * 分页查询(包含统计数据)
     * @param param 分页查询参数
     * @return 代理人邀请函配置及统计数据集合
     */
    List<SellerInvitationLetterConfDetailDto> findDetailPage(MyInvitationLetterParam param);

    /**
     * 新增代理人邀请函配置及统计信息
     * @param dto 代理人邀请函配置
     * @return 主键
     */
    Long save(SellerInvitationLetterConfDto dto);

    /**
     * 根据主键更新
     * @param dto 代理人邀请函配置
     * @return 执行结果
     */
    int update(SellerInvitationLetterConfDto dto);

    /**
     * 根据主键查询（走缓存）
     * @param id 主键
     * @return 代理人邀请函配置
     */
    SellerInvitationLetterConfDto findByIdCache(Long id);

    /**
     * 根据主键查询详情（包含统计数据）
     * 统计数据不走缓存，配置信息走缓存
     * @param id 主键
     * @return 代理人邀请函配置及统计数据
     */
    SellerInvitationLetterConfDetailDto findDetailById(Long id);
}
