package cn.com.duiba.kjy.api.dto.push;

import cn.com.duiba.kjy.api.enums.push.PushManagerEnableEnum;
import cn.com.duiba.kjy.api.enums.push.PushManagerStateEnum;
import lombok.Data;
import lombok.ToString;
import java.io.Serializable;
import java.util.Date;

/**
 * 推送管理信息
 * @author linjianhui
 * 2019-08-06
 */
@Data
@ToString
public class PushManagerDto implements Serializable {

    private static final long serialVersionUID = 4986812974837606132L;

    /**
     *
     *主键
     */
    private Long id;

    /**
     *
     *标题
     */
    private String title;

    /**
     *
     *内容id，文章、海报、活动ID等等
     */
    private Long itemId;

    /**
     *
     *类型; activity =活动、article =文章、daily =日报
     */
    private String itemType;

    /**
     *
     *场景; 1 =下午动画推荐
     */
    private Integer scenes;

    /**
     *
     *描述
     */
    private String pushDesc;

    /**
     *
     *缩略图
     */
    private String mainImgUrl;

    /**
     *
     *内容发布日期
     */
    private Date contentReleaseTime;

    /**
     *
     *是否启用推送，1=启用、2=未启用
     */
    private PushManagerEnableEnum isEnable;

    /**
     *
     *状态，1=未开始、2=成功、3=失败
     */
    private PushManagerStateEnum state;

    /**
     *
     *是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     */
    private Date gmtModified;

    /**
     * 推送公司id
     */
    private Long companyId;

    /**
     * 推送的公司名称
     */
    private String companyName;

    /**
     * 消息类型 {@link cn.com.duiba.kjy.api.enums.MessageConfigTypeEnum }
     */
    private Integer messageType;

    /**
     * 过滤类型 {@link cn.com.duiba.kjy.api.enums.push.SellerFilterTypeEnum }
     */
    private Integer sellerFilterType;

    /**
     * 推送事件
     */
    private String pushEvent;

    /**
     * 关注开始时间
     */
    private Date concentrateStart;

    /**
     * 关注结束时间
     */
    private Date concentrateEnd;

    /**
     * 指定推送版本 0:全部 1:通用版,2:保险版
     */
    private Integer pushVersion;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 需要推送的代理人ID尾号，以英文逗号分隔
     */
    private String sellerIdTailNum;

    /**
     * 推送地址
     */
    private String pushAddress;
}
