package cn.com.duiba.kjy.api.remoteservice.faq;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.faq.FaqAnxietyExtDto;

import java.util.List;

/**
 * 焦虑配置信息
 * @Author xiaotian
 * @Date 2020/07/13 7:42 下午
 */
@AdvancedFeignClient
public interface RemoteFaqAnxietyExtService {

    /**
     * 根据anxietyType查询配置列表
     */
    List<FaqAnxietyExtDto> findListByAnxietyType(Integer anxietyType);

    /**
     * 新增or更新
     *
     * @param faqAnxietyExtDto
     * @return
     */
    boolean addOrUpdate(FaqAnxietyExtDto faqAnxietyExtDto);

    /**
     * 根据anxietyType查询当前在用的配置
     *
     * @param anxietyType
     * @return
     */
    FaqAnxietyExtDto finUseExt(Integer anxietyType);

    /**
     * 根据主键Id获取
     *
     * @param id
     * @return
     */
    FaqAnxietyExtDto findById(Long id);

    /**
     * 删除测试
     * @param id
     * @return
     */
    boolean deleteTest(Long id);


    /**
     * 删除材料
     * @param id
     * @return
     */
    boolean deleteMaterial(Long id);

}
