package cn.com.duiba.kjy.api.dto.push;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 自定义推送配置表
 * @author kjj mybatis generator 
 * 2020-07-24
 */
@Data
public class CustomPushConfDto implements Serializable {
    private static final long serialVersionUID = 15955716759063514L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *推送日期
     */
    private Date contentReleaseTime;

    /**
     *
     *1:全部，2:VIP 3:非VIP 4:company
     * not null default = 1
     */
    private Integer sellerFilterType;

    /**
     *
     *所属公司id(0=共有)
     * not null default = 0
     */
    private Long companyId;

    /**
     *
     *指定推送版本 0:全部 1:通用版,2:保险版,3:教培版
     * not null default = 2
     */
    private Integer pushVersion;

    /**
     *
     *备注
     * max length = 255
     */
    private String remarks;

    /**
     *
     *需要推送的代理人ID尾号，以英文逗号分隔
     * max length = 30
     * not null default = 
     */
    private String sellerIdTailNum;

    /**
     *
     *推送地址，以逗号隔开
     * max length = 200
     * not null default = 
     */
    private String pushAddress;

    /**
     *
     *关注时间（开始）
     */
    private Date concentrateStart;

    /**
     *
     *关注时间（结束）
     */
    private Date concentrateEnd;

    /**
     *
     *是否启用推送，1=启用、2=未启用
     * not null default = 2
     */
    private Integer isEnable;

    /**
     *
     *状态，1=未开始、2=成功、3=失败
     * not null default = 1
     */
    private Integer state;

    /**
     *
     *是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Integer deleted;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     *
     *推送的目标公众号类型，和oa表的type保持一致
     */
    private Integer oaType;

    /**
     *
     *推送事件，BI统计使用
     * max length = 10
     */
    private String pushEvent;
}