package cn.com.duiba.kjy.api.params.user;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-07-08 13:38
 * @descript 访问记录es查询param
 */
@Data
public class UserVisitEsParam implements Serializable {

    private static final long serialVersionUID = 8728350156326877035L;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 访问的用户ids
     */
    private List<Long> visitorUserIds;

    /**
     * 是否为种草素材
     */
    private Integer isGrassContent;

    /**
     * 需要查询的线索类型
     */
    private List<Integer> clueTypes;

    /**
     * 内容类型
     */
    private List<String> contentTypes;

    /**
     * 分页大小
     */
    private Integer pageSize;

    /**
     * 最后一条是否曝光
     */
    private Integer lastIsNotExposed;

    /**
     * 最后一条的创建时间
     */
    private Long lastGmtCreate;

    /**
     * 最后一条的访问记录id
     */
    private Long lastVisitTableId;

    /**
     * 代理人内容id
     */
    private Long scid;

    /**
     * 是否有线索
     */
    private Integer isHasClue;

    /**
     * 是否有转发
     */
    private Integer isVisitorForward;

    /**
     * 是否有线索
     */
    private Integer isMoreRelation;

    /**
     * 排序场景
     * @see cn.com.duiba.kjy.api.enums.user.UserVisitEsSortTypeSceneEnum
     */
    private Integer orderScene;

}
