package cn.com.duiba.kjy.api.remoteservice.weekly;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.weeklystats.WeeklyContentStatsDto;
import cn.com.duiba.kjy.api.dto.weeklystats.WeeklyContentTagStatsDto;
import cn.com.duiba.kjy.api.dto.weeklystats.WeeklyCustomerClueStatsDto;
import cn.com.duiba.kjy.api.dto.weeklystats.WeeklyCustomerTimeStatsDto;
import cn.com.duiba.kjy.api.dto.weeklystats.WeeklyCustomerVisitStatsDto;
import cn.com.duiba.kjy.api.dto.weeklystats.WeeklyDateStatsDto;
import cn.com.duiba.kjy.api.dto.weeklystats.WeeklyMarketingStatsDto;
import cn.com.duiba.kjy.api.dto.weeklystats.WeeklyPlatformContentStatsDto;
import cn.com.duiba.kjy.api.dto.weeklystats.WeeklyStatsDto;
import cn.com.duiba.kjy.api.params.weekly.WeeklyStatsParam;

import java.util.List;

/**
 * 代理人周报统计
 * @Author chentiecheng
 * @Date 2020/7/13 10:38 上午
 */
@AdvancedFeignClient
public interface RemoteWeeklyStatsService {

    /**
     * 根据销售id获取最新一篇周报
     * @param sellerId
     * @return
     */
    WeeklyStatsDto getSellerLastWeekly(Long sellerId);
    /**
     * 根据销售id获取代理人周报，仅获取最近一年的
     * @param sellerId
     * @return
     */
    List<WeeklyStatsDto> getSellerWeeklyListBySellerId(Long sellerId);

    /**
     * 根据代理人id和周报id获取周报汇总信息
     * @param sellerId
     * @param id
     * @return
     */
    WeeklyStatsDto getWeeklyStatsBySellerIdAndId(Long sellerId,Long id);

    /**
     * 根据代理人id和日期获取周报内容统计信息
     * @param param
     * @return
     */
    List<WeeklyContentStatsDto> getWeeklyContentStatsByParam(WeeklyStatsParam param);

    /**
     * 根据代理人id和日期以及类型获取周报内容标签统计信息
     * @param param
     * @return
     */
    List<WeeklyContentTagStatsDto> getWeeklyContentTagStatsByParam(WeeklyStatsParam param);
    /**
     * 根据代理人id和日期获取周报客户线索统计信息
     * @param param
     * @return
     */
    List<WeeklyCustomerClueStatsDto> getWeeklyCustomerClueStatsByParam(WeeklyStatsParam param);

    /**
     * 根据代理人id和日期获取周报客户访问时段统计信息
     * @param param
     * @return
     */
    List<WeeklyCustomerTimeStatsDto> getWeeklyCustomerTimeStatsByParam(WeeklyStatsParam param);
    /**
     * 根据代理人id和日期获取周报访问次数统计信息
     * @param param
     * @return
     */
    List<WeeklyCustomerVisitStatsDto> getWeeklyCustomerVisitStatsByParam(WeeklyStatsParam param);

    /**
     * 根据代理人id和日期获取周报营销工具统计信息
     * @param param
     * @return
     */
    List<WeeklyMarketingStatsDto> getWeeklyMarketingStatsByParam(WeeklyStatsParam param);
    /**
     * 根据日期获取平台内容统计信息,转发最多的
     * @param param
     * @return
     */
    List<WeeklyPlatformContentStatsDto> getWeeklyPlatformContentStatsByParam(WeeklyStatsParam param);

    /**
     * 根据销售id和时间查询每日小结统计
     *
     */
    List<WeeklyDateStatsDto> getWeeklyDateStatsByParam(WeeklyStatsParam param);
}
