package cn.com.duiba.kjy.api.params.pay;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * @author lizhi
 * @date 2020/1/6 12:21 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WxDuiBaRefundRecordParam extends PageQuery {

    private static final long serialVersionUID = -4680056965883714418L;

    /**
     * 客集集订单号
     */
    private String bizOrderNo;

    /**
     * 兑吧分配给业务方的类型和bizOrderNo配合使用
     */
    private Integer bizType;

    /**
     * 第三方支付支付流水号,微信支付订单号
     */
    private String transactionNo;

    /**
     * 调用第三方退款，返回的退款单号
     */
    private String refundOrderNo;

    /**
     * 微信退款单号，第三方返回
     */
    private String refundNo;

    /**
     * 退款状态，第三方返回
     */
    private Integer refundStatus;

    /**
     * 客集集业务类型
     */
    private Integer kjjBizType;

    /**
     * 客集集业务对应表的主键
     */
    private Long kjjBizId;

    /**
     * 业务方的退款订单单号
     */
    private String bizRefundNo;

    /**
     * 退款状态集合
     */
    private List<Integer> refundStatusList;

    /**
     * 开始时间（包含）
     */
    private Date startTime;

    /**
     * 结束时间（不包含）
     */
    private Date endTime;
}
