package cn.com.duiba.kjy.api.params.sellercard;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 客户评价查询参数类
 * @author 吴文哲
 * @date 2020-03-17 16:34
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerCardAppraiseQueryParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 1841862233679023601L;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 访客id
     */
    private Long visitorId;

    /**
     * 客户评价状态
     * @see cn.com.duiba.kjy.api.enums.sellercard.AppraiseStateEnum
     */
    private Integer appraiseState;
    /**
     * 是否是个人评价 ，true是个人评价，false是评价模版
     */
    private Boolean isPersonal;

    /**
     * 模板案例id
     */
    private Long appraiseTemplateId;
}
