package cn.com.duiba.kjy.api.constant;

/**
 * @author wangbinbin
 * @create 2019-08-19 15:03
 * @descript
 */
public enum KjyCenterHBaseKeyEnum {
    @Deprecated
    K001("销售员上传文章总次数"),
    @Deprecated
    K002("引导销售员关注VIP公众号推送"),
    @Deprecated
    K003("销售员访问周报记录"),
    K004("动画内容"),
    K005("周报详情数据"),
    K006("代理人访客首次用户来源信息"),
    @Deprecated
    K007("互动模板 使用次数"),
    @Deprecated
    K008("互动模板 模板互动人数"),
    @Deprecated
    K009("互动模板 内容互动人数"),
    @Deprecated
    K012("每日热点内容推送"),
    @Deprecated
    K013("每日热点内容的推送标题"),
    @Deprecated
    K014("每日公司的动画推送"),
    K020("抽奖参与次数"),
    K021("抽奖分享次数"),
    K022("全网链接链接地址"),
    K023("名片成功案例key"),
    K032("公司简介图片"),
    K033("荣誉认证简介图片"),
    K034("用户导师"),
    K035("代理人点击问卷调查"),
    K036("代理人点击最佳实践官立即参与"),
    K037("代理人点击最佳实践官关闭"),
    K038("发圈素材代理人已读标记"),
    K040("首页弹层配置公司id数组"),
    @Deprecated
    K041("代理人获取公众号详情标记"),
    K042("会员续费首次弹窗"),
    K043("本周期弹出弹层或进入续费支付页缓存"),
    K044("会员续费弹窗次数"),
    ;

    private String desc;

    KjyCenterHBaseKeyEnum(String desc){
        this.desc = desc;
    }

    private static final String SPACE = "KjyCenter";
    private static final String SEPARATOR = "_";

    public String getDesc() {
        return desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg : args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }

    public static void main(String[] args) {
        System.out.println(KjyCenterHBaseKeyEnum.K003.join(7250, 6));
    }
}
