package cn.com.duiba.kjy.api.dto.comment;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 素材评论表
 * @author kjj mybatis generator 
 * 2019-11-26
 */
@Data
public class MaterialCommentDto implements Serializable {
    private static final long serialVersionUID = 15747619928885138L;

    /**
     *
     *主键
     */
    private Long id;

    /**
     *
     *代理人id
     */
    private Long sellerId;

    /**
     *
     *访客Id tb_users.id 
     */
    private Long visitorId;

    /**
     *
     *代理人内容Id tb_seller_content.id
     */
    private Long scId;

    /**
     *
     *记录类型：article =文章、seller =名片 activity =活动 daily=日报
     */
    private String contentType;


    /**
     * 内容id
     */
    private Long contentId;

    /**
     *
     *评论内容
     */
    private String visitorComment;

    /**
     *
     *评论内容是否包含敏感词  0:未知 1:包含 2:不包含
     */
    private Integer isSensitive;

    /**
     *
     *敏感词内容
     */
    private String sensitiveWord;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     */
    private Date gmtModified;
}