package cn.com.duiba.kjy.api.params;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 支付订单查询页面查询条件
 * @auther wuwenzhe
 * @date 2019-07-26 15:03
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PayOrderManageParam extends PageQuery {

    /**
     *  id
     */
    private Long id;

    /**
     * 微信交易号
     */
    private String payTradeNo;

    public String getPayTradeNo() {
        return StringUtils.isEmpty(payTradeNo)?null:payTradeNo;
    }


    /**
     * 销售微信昵称
     */
    private String nickName;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 上级ID(seller_id)
     */
    private Long superiorId;

    /**
     * 上级销售微信昵称
     */
    private String superiorNickName;

    /**
     * 所属公司id
     */
    private Long companyId;

    /**
     * 创建时间 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startGmtCreate;

    /**
     * 创建时间 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endGmtCreate;

    /**
     * 支付状态
     */
    private Integer payStatus;

    /**
     * 是否代付   0:全部 1:是  2:否
     */
    private Integer presentPay;

    /**
     * 下单时的用户版本
     */
    private Integer userVersion;



    /**
     * ----------------------以下字段仅在sql中 以in的方式使用  start---------------------------------------
     */

    /**
     * 销售员Id集合
     */
    private List<Long> sellerIdList;



    /**
     * ----------------------以下字段仅在sql中 以in的方式使用  end---------------------------------------
     */
}
