package cn.com.duiba.kjy.api.remoteservice.faq;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.faq.FaqCluePathDto;
import cn.com.duiba.kjy.api.mqmsg.SendPushForScanMsg;
import cn.com.duiba.kjy.api.params.faq.SendPushForDelayParam;
import cn.com.duiba.kjy.api.params.faq.SendPushForScanParam;

import java.util.List;

/**
 * 获取faq线索信息
 *
 * @Author xiaotian
 * @Date 2020/07/13 7:42 下午
 */
@AdvancedFeignClient
public interface RemoteFaqClueService {

    /**
     * 根据主键Id获取
     *
     * @param id
     * @return
     */
    FaqCluePathDto findById(Long id);


    /**
     * 新增线索
     *
     * @param faqCluePathDto
     * @return
     */
    Long add(FaqCluePathDto faqCluePathDto);


    /**
     * 根据主键Id获取关联的faqId列表
     *
     * @param ids
     * @return
     */
    List<Long> findFaqIdByIds(List<Long> ids);


    /**
     * 根据主键Id获取关联的资料包Id列表
     *
     * @param ids
     * @return
     */
    List<Long> findMaterialIdByIds(List<Long> ids);

    /**
     * 点击faq详情增加线索和推送
     *
     * @param sendPushForScanParam
     * @return
     */
    void sendPushForScan(SendPushForScanParam sendPushForScanParam);


    /**
     *
     * @param sendPushForScanParam
     * @return
     */
    SendPushForScanMsg getRedisMsg(SendPushForScanParam sendPushForScanParam);

    /**
     * 发送延迟消息
     * @param sendPushForDelayParam
     */
    void sendDelayMsg(SendPushForDelayParam sendPushForDelayParam);
}
