package cn.com.duiba.kjy.api.enums.versionItemConf;

import java.util.Objects;

/**
 * 版本配置  行为类型枚举
 * @author 吴文哲
 * @date 2020-04-23 17:53
 **/
public enum VersionItemConfActionTypeEnum {
    ADD(1,"新增"),
    UPDATE(2,"修改"),
    DELETE(3,"删除"),
    ;

    /**
     * 行为类型
     */
    private Integer actionType;

    /**
     * 描述
     */
    private String desc;

    VersionItemConfActionTypeEnum(Integer actionType,String desc){
        this.actionType = actionType;
        this.desc = desc;
    }

    public Integer getActionType() {
        return actionType;
    }

    public String getDesc() {
        return desc;
    }

    public static VersionItemConfActionTypeEnum getByType(Integer version){
        for (VersionItemConfActionTypeEnum enumVal : VersionItemConfActionTypeEnum.values()) {
            if (Objects.equals(version, enumVal.getActionType())) {
                return enumVal;
            }
        }
        return null;
    }
}
