package cn.com.duiba.kjy.api.dto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人来源信息异常反馈表
 * @author kjj mybatis generator 
 * 2020-02-21
 */
@Data
public class VisitPathFeedbackDto implements Serializable {
    private static final long serialVersionUID = 15822762753927241L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *销售员id，对应tb_seller.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *访客id tb_users.id
     * not null default = 0
     */
    private Long visitorId;

    /**
     *
     *1:微信好友不存在
     * not null default = null
     */
    private Integer feedbackType;

    /**
     *
     *刷新访客微信信息标识,1:标记刷新,2:刷新成功,3:刷新失败
     * not null default = 0
     */
    private Integer refreshType;

    /**
     *
     *最近刷新时间
     */
    private Date refreshTime;

    /**
     *
     *访客被标记的次数
     * not null default = 1
     */
    private Integer markTimes;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}