package cn.com.duiba.kjy.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.usingStrategy.StrategyFaqDto;
import cn.com.duiba.kjy.api.params.guide.StrategyFaqMoveParam;
import cn.com.duiba.kjy.api.params.guide.StrategyFaqQueryParam;

import java.util.List;

/**
 * 用户策略 常见问题
 * @author 吴文哲
 * @date 2020-01-13 09:53
 **/
@AdvancedFeignClient
public interface RemoteStrategyFaqService {


    /**
     * 新增/修改 常见问题
     * @param dto
     * @return
     */
    Integer addOrUpdateFaq(StrategyFaqDto dto) throws KjyCenterException;


    /**
     * 根据条件查询 FAQ列表
     * @param param
     * @return
     */
    List<StrategyFaqDto> getFaqListByCondition(StrategyFaqQueryParam param);

    /**
     * 根据条件 统计FAQ数量 用于分页
     * @param param
     * @return
     */
    Integer getFaqCountByCondition(StrategyFaqQueryParam param);

    /**
     * 在同分类下移动位置
     * @param moveParam
     * @return
     */
    Boolean moveFaqUnderTag(StrategyFaqMoveParam moveParam) throws KjyCenterException;

    /**
     * 常见问题详情
     * @param faqId
     * @return
     */
    StrategyFaqDto getDetail(Long faqId);

}
