package cn.com.duiba.kjy.api.enums.seller;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 代理人默认标签
 * @Author chentiecheng
 * @Date 2020/6/10 10:21 上午
 */
public enum SellerDefaultTagEnum {
    HAVE_INTENTION("有意向"),
    PROSPECTIVE_CUSTOMER("准客户"),
    ALREADY_SIGNING("已签单"),
    ;
    private String code;

    SellerDefaultTagEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 获取所有默认标签
     * @return
     */
    public static List<String> getAllTagName(){
        List<String> list = Arrays.stream(SellerDefaultTagEnum.values()).map(SellerDefaultTagEnum::getCode).collect(Collectors.toList());
        return list;
    }
}
