package cn.com.duiba.kjy.api.dto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * vip迁移列表dto
 * @author 吴文哲
 * @date 2020-01-20 15:34
 **/
@Data
public class VipSellerTransferListDto implements Serializable {
    private static final long serialVersionUID = 5793141868274703208L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     * 老用户
     */
    private VipSellerTransferDto oldSeller;

    /**
     * 新用户
     */
    private VipSellerTransferDto newSeller;


    /**
     *
     *操作人id
     * not null default = null
     */
    private Long operatorId;

    /**
     *
     *操作人
     * max length = 32
     * not null default = null
     */
    private String operatorAccount;

    /**
     *
     *操作原因
     * max length = 200
     * not null default = null
     */
    private String opReason;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 用户版本
     */
    private Integer userVersion;

    /**
     * 公司
     */
    private String companyName;

    /**
     * vip失效时间
     */
    private Date vipEnd;
}
