package cn.com.duiba.kjy.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/12/12 6:33 PM
 */
public enum CouponStateEnum {

    OPEN(1, "开启"),
    CLOSE(2, "关闭"),
    ;

    private Integer type;

    private String desc;

    CouponStateEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, CouponStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CouponStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getType(), stateEnum);
        }
    }

    public static CouponStateEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
