package cn.com.duiba.kjy.api.params.video;

import cn.com.duiba.kjy.api.enums.sellerImport.VideoUploadTypeEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * Created by xiaotian
 * time 2020/06/26 15:34.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class VideoSearchEsParam extends PageQuery {

    private static final long serialVersionUID = 8193939736319262450L;

    /**
     * 视频ID
     */
    private Long    contentId;

    /**
     * 上传时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date    gmtCreate;

    /**
     * 用户昵称
     */
    private String  sellerName;

    /**
     * 状态
     */
    private Integer state;

    /**
     * 一级标签
     */
    private Long firstTag;

    /**
     * 二级标签
     */
    private Long secondTag;

    /**
     * 三级标签
     */
    private Long thirdTag;

    /**
     * 视频标题
     */
    private String videoTitle;

    /**
     * 发布开始时间
     */
    private Date   releaseTimeStart;

    /**
     * 发布结束时间
     */
    private Date   releaseTimeEnd;

    /**
     * 上传类型
     * @see VideoUploadTypeEnum
     */
    private Integer uploadType;
}
