package cn.com.duiba.kjy.api.remoteservice.clockin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clockin.ClockInTaskWeekDto;

import java.util.Date;
import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2020-06-29 19:56
 * @description: 60天打卡任务-每周任务
 */
@AdvancedFeignClient
public interface RemoteClockInTaskWeekService {

    /**
     * 根据任务id和本周起始日期查询
     * @param taskId
     * @param weekStartTime
     * @return
     */
    ClockInTaskWeekDto findByTaskIdAndStartTime(Long taskId,Date weekStartTime);

    /**
     * 根据任务id查询每周任务列表
     * @param taskId
     * @return
     */
    List<ClockInTaskWeekDto> findListByTaskId(Long taskId);

}
