package cn.com.duiba.kjy.api.remoteservice.grass;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.grass.GrassContentPushDto;
import cn.com.duiba.kjy.api.dto.grass.GrassContentPushExtDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.grabmaterial.MaterialPushSearchParam;

import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2020-05-29 15:29
 * @description: 种草素材推送
 */
@AdvancedFeignClient
public interface RemoteGrassContentPushService {

    /**
     * 判断是否超限，每天最多创建3条
     * @param releaseTime
     * @return
     */
    boolean checkCount(Date releaseTime);

    /**
     * 新增/编辑 种草素材推送内容
     * @param dto
     * @return
     */
    Long saveOrUpdate(GrassContentPushDto dto);


    /**
     * 通过id删除
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    GrassContentPushDto findById(Long id);

    /**
     * 查询种草素材推送列表
     * @param params
     * @return
     */
    Page<GrassContentPushExtDto> selectList(MaterialPushSearchParam params);

}
