package cn.com.duiba.kjy.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.user.UserPermissionsDto;
import cn.com.duiba.kjy.api.enums.user.UserPermissionsTypeEnum;

/**
 * 用户权限服务
 * @author zhanghuifeng
 * date 2019/11/12-2:53 下午
 */
@AdvancedFeignClient
public interface RemoteUserPermissionsService {

    /**
     * 新增
     * @param dto
     * @return
     */
    Boolean save(UserPermissionsDto dto);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 查询
     * @param id
     * @return
     */
    UserPermissionsDto findById(Long id);

    /**
     * 根据用户和权限类型查询
     * @param userId
     * @param typeEnum
     * @return
     */
    int countBySellerPermissions(Long userId, UserPermissionsTypeEnum typeEnum);

}
