package cn.com.duiba.kjy.api.remoteservice.config;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.config.KeyToValConfDto;

import java.util.List;

/**
 * 基于mysql,类似于hbase的键值对服务
 *  * key不能超过125个字符
 *  * value可以为Long类型,也可以为string类型
 *  * string类型的value长度不能超过512
 * @author 吴文哲
 * @date 2020-08-11 10:57
 **/
@AdvancedFeignClient
public interface RemoteKeyToValService {

    /**
     * 插入一条键值对 返回主键id
     *
     * @param keyToValConfDto
     * @return 主键id
     */
    Long addKey2ValDto(KeyToValConfDto keyToValConfDto);

    /**
     * 插入一条 key为字符串 val为long类型的键值对实体
     *
     * @param key     字符串key
     * @param longVal long类型的值 存放在tb_key_to_val_conf.item_val_long中
     * @return 主键id
     * @see cn.com.duiba.kjy.api.enums.config.KeyToValEnum
     */
    Long addLongKey2ValDto(String key, Long longVal);


    /**
     * 插入一条 key为字符串 val为String类型的键值对实体
     *
     * @param key    字符串key
     * @param strVal string类型的值 存放在tb_key_to_val_conf.item_val_str中
     * @return 主键id
     * @see cn.com.duiba.kjy.api.enums.config.KeyToValEnum
     */
    Long addStrKey2ValDto(String key, String strVal);


    /**
     * 批量插入
     *
     * @param keyToValConfDtos
     * @return 插入数量
     */
    Integer batchAddDto(List<KeyToValConfDto> keyToValConfDtos);

    /**
     * 根据key更新long值 如果key不存在就会插入
     *
     * @param key
     * @param longVal
     * @return
     */
    boolean updateByKey4Long(String key, Long longVal);

    /**
     * 对key的long value做increase操作,不存在会新增一条记录
     * @param key  tb_key_to_val_conf.item_id
     * @param incrNum
     * @return 返回increase后的值
     */
    Long increaseByKey(String key, long incrNum);

    /**
     * 根据key更新String值 如果key不存在就会插入
     *
     * @param key
     * @param strVal
     * @return
     */
    boolean updateByKey4String(String key, String strVal);


    /**
     * 根据key获取对象
     *
     * @param key
     * @return
     */
    KeyToValConfDto getDtoByKey(String key);

    /**
     * 根据key列表批量获取实体对象
     *
     * @param keys
     * @return
     */
    List<KeyToValConfDto> getDtoListByKeys(List<String> keys);

    /**
     * 根据long值的key获取对应的long类型值
     *
     * @param longKey
     * @return
     */
    Long getLongValByKey(String longKey);


    /**
     * 根据String类型的key 获取对应的String类型的值
     *
     * @param strKey
     * @return
     */
    String getStrValByKey(String strKey);


    /**
     * 根据key删除
     * @param key
     * @return 返回受影响行数
     */
    Integer deleteByKey(String key);

    /**
     * 批量删除
     * @param keys
     * @return 受影响数量,可用于校验是否删除成功
     */
    Integer batchDeleteByKeys(List<String> keys);
}
