package cn.com.duiba.kjy.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2019/10/23 5:56 PM
 */
@Data
public class ActivityCustomPrizeDto implements Serializable {

    private static final long serialVersionUID = -1876706552648559919L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 活动配置ID，对应tb_seller_activity_conf.id
     */
    private Long activityConfId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图片
     */
    private String prizeImg;

    /**
     * 总库存
     */
    private Integer totalStock;

    /**
     * 剩余库存
     */
    private Integer remainingStock;

    /**
     * 中奖人，以英文逗号分隔，对应tb_activity_winner.id
     */
    private String prizeWinner;

    /**
     * 自定义奖品类型：1-销售员定制,2-销售员追加
     * @see cn.com.duiba.kjy.api.enums.lottery.CustomPrizeTypeEnum
     */
    private Integer customPrizeType;

    /**
     * 自定义奖品中奖概率
     */
    private Integer customPrizeRate;

    /**
     * 获取中奖人ID集合
     * @return 中奖人ID集合
     */
    public List<Long> getWinnerIds() {
        if (prizeWinner == null || prizeWinner.length() == 0) {
            return new ArrayList<>();
        }
        List<Long> winnerIds = new ArrayList<>();
        String[] winners = prizeWinner.split(",");
        for (String idStr : winners) {
            try {
                long id = Long.parseLong(idStr);
                winnerIds.add(id);
            } catch (NumberFormatException ignored) {
            }
        }
        return winnerIds;
    }

    public void setWinnerIds(List<Long> winnerIds) {
        if (winnerIds == null || winnerIds.size() == 0) {
            return;
        }
        prizeWinner = winnerIds.stream().map(String::valueOf).collect(Collectors.joining(","));
    }
}
