package cn.com.duiba.kjy.api.dto.interaction;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2019/9/23 1:44 PM
 */
@Data
public class ContentInteractionTemplateDto implements Serializable {

    private static final long serialVersionUID = 392576390662445009L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 模板描述
     */
    private String templateDesc;

    /**
     * 模板封面
     */
    private String mainImgUrl;

    /**
     * 模板类型, 0-投票，1-答题，2-表格
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateTypeEnum
     */
    private Integer templateType;

    /**
     * 选择类型，0-单选，1-多选
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionSelectionTypeEnum
     */
    private Integer selectionType;

    /**
     * 互动ID，tb_content_interaction_question.id
     */
    private Long interactionId;

    /**
     * 一级标签，tb_kjy_tag.id
     */
    private Long tag1Id;

    /**
     * 二级标签，tb_kjy_tag.id
     */
    private Long tag2Id;

    /**
     * 来源：1-题库，2-销售员模板
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateSourceEnum
     */
    private Integer templateSource;

    /**
     * 状态：0-未启用，1-启用
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateStateEnum
     */
    private Integer state;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}

