package cn.com.duiba.kjy.api.enums.autoreply;

import java.util.HashMap;
import java.util.Map;

/**
 * @auther: linjianhui
 * @date: 2019-12-03 17:00
 * @description: 自动回复推送版本
 */
public enum PushVersionEnum {

    /**
     * 0:全部 1:通用版,2:保险版
     */
    ALL_VERSION(0,"全部"),
    COMMON_VERSION(1,"通用版"),
    INSURANCE_VERSION(2,"保险版"),
    EDU_VERSION(3,"教培专业版"),
    ;

    private Integer code;
    private String desc;

    PushVersionEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, PushVersionEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PushVersionEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static PushVersionEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
