package cn.com.duiba.kjy.api.enums.resourceLocator;

/**
 * 资源位tab枚举
 *
 * @author 吴文哲
 * @date 2020-04-24 10:28
 **/
public enum ResourceLocatorTabEnums {
    INDEX_ICON(1,"首页icon资源位"),
    INDEX_MESSAGE_FLOAT(2,"首页信息流资源位"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    ResourceLocatorTabEnums(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ResourceLocatorTabEnums getByType(Integer code) {
        for (ResourceLocatorTabEnums enumVal : ResourceLocatorTabEnums.values()) {
            if (enumVal.getType()==code) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
