package cn.com.duiba.kjy.api.enums.sellergift;

import java.util.Objects;

/**
 * 用户奖励发放类别
 * @author xiaotian
 * @date 2020-06-16 09:31
 **/
public enum GiftTypeEnum {

    /**
     * vip时长
     */
    VIP_TIME(1,"vip时长"),
    ;

    private Integer code;

    private String desc;

    GiftTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static GiftTypeEnum getByCode(Integer code){
        for (GiftTypeEnum enumVal : GiftTypeEnum.values()) {
            if (Objects.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public static GiftTypeEnum getByDesc(String desc){
        for (GiftTypeEnum enumVal : GiftTypeEnum.values()) {
            if (Objects.equals(desc, enumVal.getDesc())) {
                return enumVal;
            }
        }
        return null;
    }
}
