package cn.com.duiba.kjy.api.remoteservice.advice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.advice.AdviceWordDto;
import cn.com.duiba.kjy.api.dto.advice.SuccessCaseDto;
import cn.com.duiba.kjy.api.params.advice.AdviceWordListParam;
import cn.com.duiba.kjy.api.params.advice.SuccessCaseListParam;

import java.util.List;

/**
 * 建议话术
 *
 * @Author xiaotian
 * @Date 2020/2/6 1:21 下午
 */
@AdvancedFeignClient
public interface RemoteSuccessCaseService {

    /**
     * 增加成功案例
     *
     * @param successCaseDto
     * @return
     */
    Boolean add(SuccessCaseDto successCaseDto);

    /**
     * 更新成功案例
     *
     * @param successCaseDto
     * @return
     */
    Boolean update(SuccessCaseDto successCaseDto);

    /**
     * 获取成功案例列表
     *
     * @return
     */
    List<SuccessCaseDto> getList(SuccessCaseListParam successCaseListParam);

}
