package cn.com.duiba.kjy.api.remoteservice.sellerTag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellerTag.SellerTagDto;

import java.util.List;

/**
 * 销售标签管理
 * @Author chentiecheng
 * @Date 2020/6/6 10:36 上午
 */
@AdvancedFeignClient
public interface RemoteSellerTagService {

    /**
     * 新增标签
     * @param dto
     * @return
     */
    Long addTag(SellerTagDto dto);

    /**
     * 更新标签
     * @param dto
     * @return
     */
    Long updateTag(SellerTagDto dto);

    /**
     * 根据销售id和标签id列表删除标签
     * @param sellerId
     * @param tagIds
     * @return
     */
    Boolean deleteTag(Long sellerId,List<Long> tagIds);

    /**
     * 根据销售id获取所有标签
     * @param sellerId
     * @return
     */
    List<SellerTagDto> getTagListBySellerId(Long sellerId);

    /**
     * 根据id列表获取标签列表
     * @param ids
     * @return
     */
    List<SellerTagDto> getTagListByIds(List<Long> ids);

    /**
     * 根据销售id获取总数
     * @param sellerId
     * @return
     */
    Integer countTagBySellerId(Long sellerId);

    /**
     * 根据销售id和标签名获取标签id
     * @param sellerId
     * @param tagName
     * @return
     */
    Long getIdBySellerIdAndTagName(Long sellerId,String tagName);

}
