package cn.com.duiba.kjy.api.dto.advice;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @author kjj mybatis generator 
 * 2020-08-17
 */
@Data
public class AdviceWordDto implements Serializable {
    private static final long serialVersionUID = 15976516645958847L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *话术类型：1:faq关联问答 2:咨询问题 3:领取资料 4:领取赠险
     * not null default = null
     */
    private Integer adviceType;

    /**
     *
     *关联外建ID
     * not null default = null
     */
    private String bizId;

    /**
     *
     *话术状态 0:删除 1:可用
     * not null default = 1
     */
    private Integer adviceStatus;

    /**
     *
     *话术人员；1:代理人 2；访客
     * not null default = null
     */
    private Integer userType;

    /**
     *
     *是否可复制 0:不可复制 1:可复制
     * not null default = 0
     */
    private Integer copyStatus;

    /**
     *
     *建议话术
     * max length = 300
     * not null default = 
     */
    private String adviceContent;

    /**
     *
     *话术关联文章Id
     * not null default = 0
     */
    private Long contentId;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}