package cn.com.duiba.kjy.api.remoteservice.layer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.layer.LayerUserRecordDto;

/**
 * 弹层用户访问记录rpc服务类
 * @author 吴文哲
 * @date 2020-03-25 18:49
 **/
@AdvancedFeignClient
public interface RemoteLayerUserRecordService {

    /**
     * 根据用户id 配置拓展信息查询 详情
     * @param userId
     * @param extId
     * @return
     */
    LayerUserRecordDto findByUserIdAndExtId(Long userId, Long extId);

    /**
     * 新增弹层用户记录
     * @param dto
     * @return
     */
    Integer addLayerUserRecord(LayerUserRecordDto dto);
}
