package cn.com.duiba.kjy.api.params.home;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-03-25 14:08
 * @descript 首页频道页公众号查询param
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SubscriptionParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -6251634874546590047L;

    /**
     * 公众号名称
     */
    private String subName;

    /**
     * 公众号标签id
     */
    private Long subTagId;

    /**
     * 爬虫管理中的id
     */
    private Long grabWebId;

    /**
     * 是否开启
     */
    private Integer isOpen;

    /**
     * 排除这些主键id的数据
     */
    private List<Long> excludeIds;

}
