package cn.com.duiba.kjy.api.remoteservice.animation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.animation.AnimationMaterialDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.animation.AnimationMaterialParams;

/**
 * @author lizhi
 * @date 2019/8/23 2:07 PM
 */
@AdvancedFeignClient
public interface RemoteAnimationMaterialService {

    /**
     * 保存素材
     * @param dto 素材信息
     * @return 主键
     */
    Long save(AnimationMaterialDto dto);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 素材信息
     */
    AnimationMaterialDto findById(Long id);

    /**
     * 分页查询
     * @param params 查询参数
     * @return 素材列表
     */
    Page<AnimationMaterialDto> selectPage(AnimationMaterialParams params);

    /**
     * 根据主键逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    int deleted(Long id);

}
