package cn.com.duiba.kjy.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售员支付订单分销关系快照信息
 * @author zhanghuifeng
 * date 2019/12/24-4:38 下午
 */
@Data
public class OrderDistributionSnapshotDto implements Serializable {
    private static final long serialVersionUID = 7134272204631368507L;

    /**
     * 支付订单记录ID
     */
    private Long payRecordId;

    /**
     * 销售员id
     */
    private Long sellerId;

    /**
     * 上级ID(seller_id)
     */
    private Long superiorId;

    /**
     * 绑定时间
     */
    private Date bindingTime;

    /**
     * 累计推广收益
     */
    private Integer totalPromotionEarnings;

    /**
     * 客集集来源
     */
    private Integer accessSource;

    /**
     * 保护期到期时间
     */
    private Date protectExpireDate;

}
