package cn.com.duiba.kjy.api.dto.innersalesmng;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 内部销售管理表
 * @author kjj mybatis generator
 * 2020-01-06
 */
@Data
public class InnerSalesDto implements Serializable {
    private static final long serialVersionUID = 15782938904245924L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *通过union_id关联的用户ID
     * not null default = null
     */
    private Long userId;

    /**
     *
     *销售名称
     * max length = 50
     */
    private String realName;

    /**
     *
     *省份
     */
    private Long province;

    /**
     *
     *城市
     */
    private Long city;

    /**
     * 手机号
     */
    private String phone;

    /**
     *
     *角色权限 0:初始权限，待审核。1:代理人权限，2:经理权限 3:管理员权限
     * not null default = 0
     */
    private Integer permission;

    /**
     *
     *状态：1:有效，0:无效
     * not null default = 1
     */
    private Integer status;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}
